# May 1993, adamb: added vsnd, vrcv, vrcv_done
BEGIN { curnode = 0;

		picl["trace_start"]		= 1;
		picl["open"] 			= 2;
		picl["load"] 			= 3;
		picl["send"] 			= 4;
		picl["recv"] 			= 6;
		picl["recv_blocking"] 	= 7;
		picl["recv_waking"] 	= 8;
		picl["message"] 		= 9;
		picl["sync"] 			= 10;
		picl["compstate"] 		= 11;
		picl["commstate"] 		= 12;
		picl["close"] 			= 13;
		picl["trace_level"] 	= 14;
		picl["trace_mark"] 		= 15;
		picl["trace_message"] 	= 16;
		picl["trace_stop"] 		= 17;
		picl["trace_flush"] 	= 18;
		picl["trace_exit"] 		= 19;
		picl["trace_begin"] 	= 20;
		picl["trace_end"] 		= 21;
		picl["host"]			= -32768;

		xab["enroll"] 	 = 18;
		xab["initiate"]	 = 19;
		xab["initiate_done"]	 = 35;
		xab["leave"] 	 = 21;
		xab["rcv"] 		 = 24;
		xab["vrcv"]      = 40;
		xab["snd"] 		 = 28;
		xab["vsnd"]      = 42;
		xab["whoami"] 	 = 32;
		xab["rcv_done"]	 = 33;
		xab["vrcv_done"] = 41;
		}

# get rid of the extra lines
/^[^0-9]/  { next; }


# if it's an initiate
$3 == xab["initiate"] {
	pending[$5 $6] = $8;
	}

#if it's an initaite done
$3 == xab["initiate_done"] {
	k = pending[$5 $6] $8
	if (node[k] == "") {
		node[k] = curnode++
		# start tracing on this node
		print picl["trace_start"], 0, 0, node[k], 0, 0, 0;
		}
	}
	
# if it's enroll, assign a node number 
$3 == xab["enroll"] || $3 == xab["whoami"] { 
	# if the node isn't known already 
	if (node[$5 $6] == "") {
		node[$5 $6] = curnode++ 
		if(bsec == "") {
			# store the base time
			while (length($2) < 6) $2 = "0" $2;
			bsec = $1 "." $2;
			}
		# start tracing on this node
		print picl["trace_start"], 0, 0, node[$5 $6], 0, 0, 0;
		}
	}

# if it's send, generate the PICL event, use serial number for length 
# January 1993: convert broadcasts to multiple sends (bergmark)
$3 == xab["snd"] || $3 == xab["vsnd"] {
	while (length($2) < 6) $2 = "0" $2;
	ttime = $1"."$2;
	ttime = ttime - bsec;
	nsf = split(ttime, tsec, ".");
	while (length(tsec[2]) < 6) tsec[2] = tsec[2] "0";
	if ($12 == -1) {               # dest=-1, a broadcast
# Note, this won't work if the initiates haven't enrolled yet
	for (k in node) { #loop over all defined nodes 
		if ( node[k] != node[$5 $6] ) {
			if ( k ~ $10 ) {
				dest = node[k]
				print picl["send"], tsec[1], tsec[2], node[$5 $6], dest, $14, $16;
	      		} # end if same instance name
	      	} # end if not myself
		}    # end for loop
	}       # end if dest = -1
	# the original code (target is not -1)
	else {
	   dest = node[$10 $12];
	   if (dest == "") dest = "-32768";
	   print picl["send"], tsec[1], tsec[2], node[$5 $6], dest, $14, $16;
       }
	}

# if it's rcv, generate the PICL event
$3 == xab["rcv"] || $3 == xab["vrcv"] { 
	while (length($2) < 6) $2 = "0" $2;
	ttime = $1 "." $2;
	ttime = ttime - bsec;
	split(ttime, tsec, ".");
	while (length(tsec[2]) < 6) tsec[2] = tsec[2] "0";
	print picl["recv_blocking"], tsec[1], tsec[2], node[$5 $6], $8
	}

# if it's rcv_done
$3 == xab["rcv_done"] || $3 == xab["vrcv_done"] {
	while (length($2) < 6) $2 = "0" $2;
	ttime = $1 "." $2;
	ttime = ttime - bsec;
	split(ttime, tsec, ".");
	while (length(tsec[2]) < 6) tsec[2] = tsec[2] "0";
	print picl["recv_waking"], tsec[1], tsec[2], node[$5 $6], node[$10 $12], $14, $16
	}
	

# if it's leave
$3 == xab["leave"] {
	while (length($2) < 6) $2 = "0" $2;
	ttime = $1 "." $2;
	ttime = ttime - bsec;
	split(ttime, tsec, ".");
	while (length(tsec[2]) < 6) tsec[2] = tsec[2] "0";
	print picl["close"], tsec[1], tsec[2], node[$5 $6]
	}

# END	{ for (comp in node)
# 		print comp, node[comp]
#	}
